function guiSlider
% guiSlider is a GUI with a slider
% Format: guiSlider or guiSlider()
  
f = figure('Visible', 'off','color','white','Units',...
    'Normalized', 'Position', [.25 .5 .4 .2]);
 
% Minimum and maximum values for slider
minval = 0;
maxval = 5;
 
% Create the slider object
slhan = uicontrol('Style','slider', 'Units', 'Normalized', ...
    'Position',[.3 .5 .4 .2], 'Min', minval, 'Max', maxval,...
    'SliderStep', [0.5 0.5], 'Callback', @callbackfn);
% Text boxes to show the minimum and maximum values
hmintext = uicontrol('Style','text','BackgroundColor','white', ...
    'Units', 'Normalized',...
    'Position', [.1 .5 .1 .1], 'String', num2str(minval));
hmaxtext = uicontrol('Style', 'text','BackgroundColor','white',...
    'Units', 'Normalized',...
    'Position', [.8 .5 .1 .1], 'String', num2str(maxval));
% Text box to show the current value (off for now)
hsttext = uicontrol('Style','text','BackgroundColor','white',...
    'Units', 'Normalized',...
    'Position',[.4 .3 .2 .1],'Visible', 'off');

movegui(f,'center')
f.Name = 'Slider Example';
f.Visible = 'on';
 
% Call back function displays the current slider value
   function callbackfn(hObject,eventdata)
       % callbackfn is called by the 'Callback' property
       % in the slider
       num = slhan.Value;
       set(hsttext,'Visible','on','String',num2str(num))
    end
end
